/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.search;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.typebinding.ITypeBinding;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org2.eclipse.php.internal.core.ast.nodes.Assignment;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.Statement;
import org2.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.Messages;

public class ClassMembersOccurrencesFinder
extends AbstractOccurrencesFinder {
    private static final String THIS = "this";
    public static final String ID = "ClassMembersOccurrencesFinder";
    private String classMemberName;
    private String typeDeclarationName;
    private boolean isMethod;
    private IType dispatcherType;
    private IType dispatcherNamespace;
    private ASTNode erroneousNode;
    private Stack<String> currentClass = new Stack();

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.fProblems = ClassMembersOccurrencesFinder.getProblems(root);
        this.typeDeclarationName = null;
        this.isMethod = false;
        if (node.getType() == 33) {
            Identifier identifier = (Identifier)node;
            IType[] types = this.resolveDispatcherType(identifier);
            if (types != null) {
                this.dispatcherNamespace = types[0];
                this.dispatcherType = types[1];
            }
            this.classMemberName = identifier.getName();
            ASTNode parent = identifier.getParent();
            int type = parent.getType();
            this.isMethod = type == 29 || parent.getLocationInParent() == FunctionName.NAME_PROPERTY || parent.getLocationInParent() == FunctionInvocation.FUNCTION_PROPERTY;
            while (this.typeDeclarationName == null && parent != this.fASTRoot) {
                if (type == 12 || type == 40) {
                    this.typeDeclarationName = ((TypeDeclaration)parent).getName().getName();
                    break;
                }
                parent = parent.getParent();
                type = parent.getType();
            }
            if (this.hasProblems(node.getStart(), node.getEnd())) {
                this.erroneousNode = node;
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private IType[] resolveDispatcherType(Identifier identifier) {
        IType[] types = new IType[2];
        ITypeBinding typeBinding = null;
        ASTNode parent = identifier.getParent();
        if (THIS.equals(identifier.getName())) {
            return this.resolveDeclaringClassType(identifier.getParent());
        }
        if (parent.getType() == 60) {
            Variable var = (Variable)parent;
            ASTNode varParent = var.getParent();
            if (varParent.getType() == 0) {
                varParent = varParent.getParent();
            }
            if (varParent.getType() == 24 && ((FieldAccess)varParent).getDispatcher() != null) {
                typeBinding = ((FieldAccess)varParent).getDispatcher().resolveTypeBinding();
            } else if (varParent.getType() == 52) {
                typeBinding = ((StaticFieldAccess)varParent).getClassName().resolveTypeBinding();
            } else if (varParent.getType() == 31) {
                FunctionInvocation fi;
                FunctionName fn = (FunctionName)varParent;
                if (fn.getParent().getType() == 30 && (fi = (FunctionInvocation)fn.getParent()).getParent().getType() == 43 && ((MethodInvocation)fi.getParent()).getDispatcher() != null) {
                    typeBinding = ((MethodInvocation)fi.getParent()).getDispatcher().resolveTypeBinding();
                }
            } else if (varParent.getType() == 63) {
                return this.resolveDeclaringClassType(var.getParent());
            }
        } else if (parent.getType() == 31) {
            FunctionInvocation fi;
            FunctionName fn = (FunctionName)parent;
            if (fn.getParent().getType() == 30 && (fi = (FunctionInvocation)fn.getParent()).getParent().getType() == 53) {
                typeBinding = ((StaticMethodInvocation)fi.getParent()).getClassName().resolveTypeBinding();
            }
        } else if (parent.getType() == 10) {
            StaticConstantAccess sca = (StaticConstantAccess)parent;
            typeBinding = sca.getClassName().resolveTypeBinding();
        } else if (parent.getType() == 52) {
            StaticFieldAccess sfa = (StaticFieldAccess)parent;
            typeBinding = sfa.getClassName().resolveTypeBinding();
        } else {
            if (parent.getType() == 42) {
                MethodDeclaration md = (MethodDeclaration)parent;
                return this.resolveDeclaringClassType(md);
            }
            if (parent.getType() == 29) {
                FunctionDeclaration fd = (FunctionDeclaration)parent;
                return this.resolveDeclaringClassType(fd);
            }
            if (parent.getType() == 11) {
                ConstantDeclaration ccd = (ConstantDeclaration)parent;
                return this.resolveDeclaringClassType(ccd);
            }
        }
        if (typeBinding != null && typeBinding.isClass() && typeBinding.getPHPElement() != null) {
            IModelElement element = typeBinding.getPHPElement().getParent();
            if (element instanceof IType) {
                types[0] = (IType)element;
            }
            types[1] = typeBinding.getPHPElement();
            return types;
        }
        return null;
    }

    private boolean isDispatcherTypeEquals(Identifier identifier) {
        IType[] types = this.resolveDispatcherType(identifier);
        if (types != null) {
            if (this.dispatcherNamespace == null) {
                if (types[0] != null) {
                    return false;
                }
                return this.dispatcherType.equals(types[1]);
            }
            return this.dispatcherNamespace.equals(types[0]) && this.dispatcherType.equals(types[1]);
        }
        return false;
    }

    protected IType[] resolveDeclaringClassType(ASTNode node) {
        IType[] types = new IType[2];
        ASTNode parent = node.getParent();
        TypeDeclaration typeDeclaration = null;
        NamespaceDeclaration namespaceDeclaration = null;
        while (typeDeclaration == null && parent != null) {
            if (parent.getType() == 12 || parent.getType() == 40) {
                typeDeclaration = (TypeDeclaration)parent;
            }
            parent = parent.getParent();
        }
        while (namespaceDeclaration == null && parent != null) {
            if (parent.getType() == 64) {
                namespaceDeclaration = (NamespaceDeclaration)parent;
            }
            parent = parent.getParent();
        }
        if (typeDeclaration != null) {
            ITypeBinding typeBinding;
            if (namespaceDeclaration != null && namespaceDeclaration.getName() != null) {
                ISourceModule source = namespaceDeclaration.getProgramRoot().getSourceModule();
                IType iType = types[0] = source != null ? source.getType(namespaceDeclaration.getName().getName()) : null;
            }
            if ((typeBinding = typeDeclaration.resolveTypeBinding()) != null) {
                types[1] = typeBinding.getPHPElement();
            }
            return types;
        }
        return null;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = this.isMethod ? Messages.format(BASE_DESCRIPTION, String.valueOf(this.classMemberName) + "()") : Messages.format(BASE_DESCRIPTION, this.classMemberName);
        if (this.erroneousNode != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.erroneousNode.getStart(), this.erroneousNode.getLength(), this.getOccurrenceType(this.erroneousNode), this.fDescription));
        } else {
            this.fASTRoot.accept(this);
        }
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        this.currentClass.push(classDeclaration.getName().getName());
        this.checkTypeDeclaration(classDeclaration);
        return false;
    }

    @Override
    public void endVisit(ClassDeclaration classDeclaration) {
        if (!this.currentClass.isEmpty()) {
            this.currentClass.pop();
        }
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.checkTypeDeclaration(interfaceDeclaration);
        return false;
    }

    @Override
    public boolean visit(Identifier identifier) {
        if (THIS.equals(identifier.getName()) && this.classMemberName.equals(THIS)) {
            String wrappingClass;
            String string = wrappingClass = this.currentClass.isEmpty() ? null : this.currentClass.peek();
            if (wrappingClass != null && wrappingClass.equals(this.typeDeclarationName)) {
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(identifier.getStart() - 1, identifier.getLength() + 1, this.getOccurrenceType(identifier), this.fDescription));
            }
        }
        return super.visit(identifier);
    }

    @Override
    public boolean visit(MethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch(methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch(fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    @Override
    public boolean visit(StaticConstantAccess classConstantAccess) {
        Identifier constant = classConstantAccess.getConstant();
        if (this.classMemberName.equals(constant.getName())) {
            if (this.dispatcherType != null) {
                if (this.isDispatcherTypeEquals(constant)) {
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType(constant), this.fDescription));
                }
            } else {
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType(constant), this.fDescription));
            }
        }
        return true;
    }

    @Override
    public boolean visit(StaticMethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch(methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    @Override
    public boolean visit(StaticFieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch(fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    private void checkDispatch(ASTNode node) {
        Expression id;
        while (node.getType() == 0) {
            node = ((ArrayAccess)node).getName();
        }
        if (node.getType() == 33 && ((Identifier)(id = (Identifier)node)).getName().equalsIgnoreCase(this.classMemberName)) {
            if (this.dispatcherType != null) {
                if (this.isDispatcherTypeEquals((Identifier)id)) {
                    if (id.getParent() instanceof Variable) {
                        this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(id.getParent().getStart(), id.getParent().getLength(), this.getOccurrenceType(node), this.fDescription));
                    } else {
                        this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(node), this.fDescription));
                    }
                }
            } else {
                int start = node.getStart();
                int length = node.getLength();
                if (node.getParent().getType() == 60 && ((Variable)node.getParent()).isDollared() && start - 1 >= 0) {
                    --start;
                    ++length;
                }
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(start, length, this.getOccurrenceType(node), this.fDescription));
            }
        }
        if (node.getType() == 60) {
            id = (Variable)node;
            this.checkDispatch(((Variable)id).getName());
        }
    }

    private void checkTypeDeclaration(TypeDeclaration typeDeclaration) {
        assert (typeDeclaration != null);
        Block body = typeDeclaration.getBody();
        List<Statement> statements = body.statements();
        for (Statement statement : statements) {
            Object variableNames;
            Statement classVariableDeclaration;
            if (statement.getType() == 42) {
                Identifier functionName;
                MethodDeclaration classMethodDeclaration = (MethodDeclaration)statement;
                if (!this.isMethod || !this.classMemberName.equalsIgnoreCase((functionName = classMethodDeclaration.getFunction().getFunctionName()).getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.isDispatcherTypeEquals(functionName)) continue;
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType(functionName), this.fDescription));
                    continue;
                }
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType(functionName), this.fDescription));
                continue;
            }
            if (statement.getType() == 25) {
                if (this.isMethod) continue;
                classVariableDeclaration = (FieldsDeclaration)statement;
                variableNames = ((FieldsDeclaration)classVariableDeclaration).getVariableNames();
                int j = 0;
                while (j < ((Object)variableNames).length) {
                    assert (((Variable)variableNames[j]).getName().getType() == 33);
                    Identifier variable = (Identifier)((Variable)variableNames[j]).getName();
                    if (this.classMemberName.equals(variable.getName())) {
                        if (this.dispatcherType != null) {
                            if (this.isDispatcherTypeEquals(variable)) {
                                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                            }
                        } else {
                            this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                        }
                    }
                    ++j;
                }
                continue;
            }
            if (statement.getType() != 11) continue;
            classVariableDeclaration = (ConstantDeclaration)statement;
            variableNames = ((ConstantDeclaration)classVariableDeclaration).names();
            Iterator iterator = variableNames.iterator();
            while (iterator.hasNext()) {
                Identifier name = (Identifier)iterator.next();
                if (!this.classMemberName.equals(name.getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.isDispatcherTypeEquals(name)) continue;
                    this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType(name), this.fDescription));
                    continue;
                }
                this.addOccurrence(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType(name), this.fDescription));
            }
        }
        body.accept(this);
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        if (node.getParent().getType() == 11 || this.isInAssignment(node)) {
            return 1;
        }
        return 2;
    }

    protected boolean isInAssignment(ASTNode node) {
        FieldAccess fAccess;
        Variable var;
        return node.getParent().getType() == 60 && (var = (Variable)node.getParent()).getParent().getType() == 24 && (fAccess = (FieldAccess)var.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY;
    }

    @Override
    public String getElementName() {
        return this.classMemberName;
    }

    @Override
    public String getID() {
        return ID;
    }
}

